implementation module StdTimerReceiver

//	Clean Standard Object I/O library, version 1.1

import	StdTuple, StdList
import	commondef, id, receiveraccess, receiverdefaccess, StdTimerElementClass, timerhandle


instance TimerElements (Receiver m)
where
	timerElementToHandles :: !(Receiver m .ls .ps) -> [TimerElementState .ls .ps]
	timerElementToHandles (Receiver rid f atts)
		= [TimerElementHandleToTimerElementState
			(TimerReceiverHandle {	tReceiverHandle	= newReceiverHandle id (getSelectState atts) (getConnected atts) f
								 ,	tReceiverAtts	= [TimerId id:map ReceiverAttToTimerAtt atts]
								 })
		  ]
	where
		id	= RIdtoId rid
	
	getTimerElementType :: (Receiver m .ls .ps) -> TimerElementType
	getTimerElementType _ = "Receiver"

instance TimerElements (Receiver2 m r)
where
	timerElementToHandles :: !(Receiver2 m r .ls .ps) -> [TimerElementState .ls .ps]
	timerElementToHandles (Receiver2 rid f atts)
		= [TimerElementHandleToTimerElementState
			(TimerReceiverHandle {	tReceiverHandle	= newReceiverHandle2 id (getSelectState atts) (getConnected atts) f
								 ,	tReceiverAtts	= [TimerId id:map ReceiverAttToTimerAtt atts]
								 })
		  ]
	where
		id	= R2IdtoId rid
	
	getTimerElementType :: (Receiver2 m r .ls .ps) -> TimerElementType
	getTimerElementType _ = "Receiver2"

ReceiverAttToTimerAtt :: !(ReceiverAttribute .ps) -> TimerAttribute .ps
ReceiverAttToTimerAtt (ReceiverSelectState s)
	= TimerSelectState s
